# AD - Active Directory
## AD com Nxfilter
### Passo a Passo
- passo 1: Configurar zona DNS em DNS > Zone File
- passo 2: Prencher as seguintes informações <br> Campo "__Domain__" > '_adventistas.local_' e no campo "__Description__" > '_ADVENTISTAS_'
- passo 3: depois de gerado, clicar no botão __Edit__
- passo 4: Mudar o __IP__ e __NOME DO DC__ do Modelo abaixo

<br>OBS:. Caso tenha apenas 1 DC, remover as configurações referente ao DC02

### Modelo:
```
@              IN  SOA      ns1.adventistas.local. hostmaster.adventistas.local. (
                              2023070401 ;serial
                              900 ;refresh
                              600 ;retry
                              604800 ;expire
                              86400 ;minimum
                             )
                  IN  NS       ns1.adventistas.local.
                  IN  A          10.11.0.3
;server host definitions
ns1              IN  NS          10.11.0.3
ns1              IN  A           10.11.0.3
usb-dc01    	 IN  A           10.11.0.3
usb-dc02    	 IN  A           10.11.0.4

; Records Request of DC01 By TCP
_kerberos._tcp.adventistas.local.			 	 IN SRV 0 100 88 usb-dc01.adventistas.local.
_ldap._tcp.adventistas.local.					 IN SRV 0 100 389 usb-dc01.adventistas.local.
_ldap._tcp.dc._msdcs.adventistas.local.      	 IN SRV 0 100 389 usb-dc01.adventistas.local.
_ldap._tcp.Site-USB._sites.dc._msdcs.adventistas.local.      	         IN SRV 0 100 389 usb-dc01.adventistas.local.
_kpasswd._tcp.adventistas.local.				 IN SRV 0 100 464 usb-dc01.adventistas.local.
_gc._tcp.adventistas.local.						 IN SRV 0 100 3268 usb-dc01.adventistas.local.

; Records Request of DC01 By UDP
_kerberos._udp.adventistas.local.				 IN SRV 0 100 88 usb-dc01.adventistas.local.
_kpasswd._udp.adventistas.local.				 IN SRV 0 100 464 usb-dc01.adventistas.local.

; Records Request of DC02 By TCP
_kerberos._tcp.adventistas.local.				 IN SRV 0 100 88 usb-dc02.adventistas.local.
_ldap._tcp.dc._msdcs.adventistas.local. 	     IN SRV 0 100 389 usb-dc02.adventistas.local.
_ldap._tcp.Site-USB._sites.dc._msdcs.adventistas.local.      	         IN SRV 0 100 389 usb-dc02.adventistas.local.
_ldap._tcp.adventistas.local.					 IN SRV 0 100 389 usb-dc02.adventistas.local.
_kpasswd._tcp.adventistas.local.  				 IN SRV 0 100 464 usb-dc02.adventistas.local.
_gc._tcp.adventistas.local.						 IN SRV 0 100 3268 usb-dc02.adventistas.local.

; Records Request of DC02 By UDP
_kerberos._udp.adventistas.local. 				 IN SRV 0 100 88 usb-dc02.adventistas.local.
_kpasswd._udp.adventistas.local.  				 IN SRV 0 100 464 usb-dc02.adventistas.local.
```

## AD com Nxfilter para  MacOs
Para o MACos, seguir o procedimento inicial descrito em [AD com Nxfilter](http://git.usb.org.br/infra/scripts#ad-com-nxfilter)
<br> Na seguencia realizar os seguintes passos
- passo 1 : Edite o /etc/hosts
```
echo "10.11.0.3  usb-dc01 usb-dc01.adventistas.local adventistas.local" >> /etc/hosts
echo "10.11.0.4  usb-dc01 usb-dc02.adventistas.local adventistas.local" >> /etc/hosts
```
- passo 2 : Ajuste o nome da maquina conforme o padrão do IATec.
- passo 3 : Abra o terminal e executar o seguinte comando onde <USERNAME> é o usuário de administrador do AD para juntar a maquina ao dominio e <SERVER>.

```
sudo dsconfigad -u <USERNAME> -protocol smb -shell "/bin/bash" -ou "CN=Computers,DC=adventistas,DC=local" -domain adventistas.local -mobile enable -mobileconfirm enable -localhome enable -useuncpath enable -groups "Domain Admins,Enterprise Admins" -preferred <SERVER> -alldomains disable

```
- passo 4 : reiniciar o Mac Os
- passo 5 : Faça login com o usuário local do sistema
- passo 6 : Abra um terminal e crie o arquivo __scan_domain.sh__ conforme modelo:
- passo 7 : Altere as variaveis __SVC_ACCOUNT_NAME__, __SVC_ACCOUNT_PASS__, __LDAP_SERVER__, __SEARCH_BASE__.
- passo 8 : Reinicie e faça login com o usuário desejado.

### Modelo  scan_domain.sh

```
#!/bin/bash

## Start by loading up our ldap query variables
SVC_ACCOUNT_NAME="Username"
SVC_ACCOUNT_PASS="Password"
DOMAIN="adventistas.local"
LDAP_SERVER="usb-dc01.adventistas.local:389"
SEARCH_BASE="OU=Users,OU=USB,OU=Sites,DC=adventistas,DC=local"

DECODE_BASE64(){
    # This function takes the encoded output from ldapsearch and decodes it 
    # It then needs to be "hex-dumped" in order to get it into regular text
    # So that we can work with it
    OBJECT_ID="$1"
    BASE64_DECODED=$(echo $OBJECT_ID | base64 -D)
    G=($(echo ${BASE64_DECODED} | hexdump -e '16/1 " %02X"'))
    OBJECTGUID="${G[3]}${G[2]}${G[1]}${G[0]}–${G[5]}${G[4]}–${G[7]}${G[6]}–${G[8]}${G[9]}–${G[10]}${G[11]}${G[12]}${G[13]}${G[14]}${G[15]}"
}

# Search LDAP for our user account
RESULT=$(ldapsearch -LLL -H ldap://$LDAP_SERVER -E pr=1000/noprompt -o ldif-wrap=no -x -D ${SVC_ACCOUNT_NAME}@$DOMAIN -w ${SVC_ACCOUNT_PASS} -b "${SEARCH_BASE}" \
-s sub -a always "(objectClass=user)" "sAMAccountName" "objectGUID")

i=1
s=1
declare -a RESULT_ARRAY
while IFS= read -r line; do
    # If we find an empty line, then we increase the counter (i), 
    # set the flag (s) to one, and skip to the next line
    [[ $line == "" ]] && ((i++)) && s=1 && continue 

    # If the flag (s) is zero, then we are not in a new line of the block
    # so we set the value of the array to be the previous value concatenated
    # with the current line
    [[ $s == 0 ]] && RESULT_ARRAY[$i]="${RESULT_ARRAY[$i]}
$line" || { 
            # Otherwise we are in the first line of the block, so we set the value
            # of the array to the current line, and then we reset the flag (s) to zero 
            RESULT_ARRAY[$i]="$line"
            s=0; 
    }
done <<< "$RESULT"

for USER in "${RESULT_ARRAY[@]}"; do
    USER_DN=$(echo "$USER" | grep "dn:")
    USER_GUID_BASE64=$(echo "$USER" | awk -F "::" '/objectGUID/ {print $2}')
    # Get our GeneratedUID from LDAPSEARCH by decoding and hex dumping it
    DECODE_BASE64 "$USER_GUID_BASE64"
    # Now lets get the first 32 bits of our GUID
    GUID_32=${OBJECTGUID:0:8}
    # Now convert this to decimal
    GUID_32_DEC=$(echo "ibase=16; $GUID_32" | bc)
    if [ $GUID_32_DEC -gt 2147483647 ]; then
        # Get the first character of our 32bit GUID
        FIRST_CHAR=${GUID_32:0:1}
        # Use the below table to replace the first character with number it represents. ie: A=2
        case $FIRST_CHAR in
            A)
                NUMBER=2 ;;
            B)
                NUMBER=3 ;;
            C)
                NUMBER=4 ;;
            D)
                NUMBER=5 ;;
            E)
                NUMBER=6 ;;
            F)
                NUMBER=7 ;;
            9)
                NUMBER=1 ;;
            8)
                NUMBER=0 ;;
            *)
        esac
        # Now lets replace the first character with our new number
        A=$(echo $GUID_32 | cut -c2-)
        NEW_32_GUID="${NUMBER}${A}"
        GUID_32_DEC=$(echo "ibase=16; $NEW_32_GUID" | bc)
    fi
    # Echo our output
    USERNAME=$(echo $USER_DN | awk -F "dn:" '{print $2}')
    echo "$USERNAME,$GUID_32_DEC"
    echo "$USERNAME,$GUID_32_DEC" >> users_with_UID.csv
done 
```